/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.computer;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.WorkMonitor;
import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.computer.Computer;
import dan200.computercraft.core.computer.ComputerEnvironment;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.core.computer.GlobalEnvironment;
import dan200.computercraft.core.filesystem.FileSystem;
import dan200.computercraft.core.metrics.MetricsObserver;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.util.PeripheralHelpers;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import org.jspecify.annotations.Nullable;

public final class Environment
implements IAPIEnvironment {
    private final Computer computer;
    private final ComputerEnvironment environment;
    private final MetricsObserver metrics;
    private final IPeripheral[] peripherals = new IPeripheral[6];
    private @Nullable IAPIEnvironment.IPeripheralChangeListener peripheralListener = null;
    private final Int2ObjectMap<Timer> timers = new Int2ObjectOpenHashMap();
    private int nextTimerToken = 0;

    Environment(Computer computer, ComputerEnvironment environment) {
        this.computer = computer;
        this.environment = environment;
        this.metrics = environment.getMetrics();
    }

    @Override
    public int getComputerID() {
        return this.computer.getID();
    }

    @Override
    public ComputerEnvironment getComputerEnvironment() {
        return this.environment;
    }

    @Override
    public GlobalEnvironment getGlobalEnvironment() {
        return this.computer.getGlobalEnvironment();
    }

    @Override
    public WorkMonitor getMainThreadMonitor() {
        return this.computer.getMainThreadMonitor();
    }

    @Override
    public Terminal getTerminal() {
        return this.computer.getTerminal();
    }

    @Override
    public FileSystem getFileSystem() {
        return this.computer.getFileSystem();
    }

    @Override
    public void shutdown() {
        this.computer.shutdown();
    }

    @Override
    public void reboot() {
        this.computer.reboot();
    }

    @Override
    public void queueEvent(String event, Object ... args) {
        this.computer.queueEvent(event, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        Int2ObjectMap<Timer> int2ObjectMap = this.timers;
        synchronized (int2ObjectMap) {
            this.timers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tick() {
        Int2ObjectMap<Timer> int2ObjectMap = this.timers;
        synchronized (int2ObjectMap) {
            ObjectIterator it = this.timers.int2ObjectEntrySet().iterator();
            while (it.hasNext()) {
                Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)it.next();
                Timer timer = (Timer)entry.getValue();
                --timer.ticksLeft;
                if (timer.ticksLeft > 0L) continue;
                this.queueEvent("timer", entry.getIntKey());
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable IPeripheral getPeripheral(ComputerSide side) {
        IPeripheral[] iPeripheralArray = this.peripherals;
        synchronized (this.peripherals) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.peripherals[side.ordinal()];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPeripheral(ComputerSide side, @Nullable IPeripheral peripheral) {
        IPeripheral[] iPeripheralArray = this.peripherals;
        synchronized (this.peripherals) {
            int index = side.ordinal();
            IPeripheral existing = this.peripherals[index];
            if (!PeripheralHelpers.equals(existing, peripheral)) {
                this.peripherals[index] = peripheral;
                if (this.peripheralListener != null) {
                    this.peripheralListener.onPeripheralChanged(side, peripheral);
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPeripheralChangeListener(@Nullable IAPIEnvironment.IPeripheralChangeListener listener) {
        IPeripheral[] iPeripheralArray = this.peripherals;
        synchronized (this.peripherals) {
            this.peripheralListener = listener;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public @Nullable String getLabel() {
        return this.computer.getLabel();
    }

    @Override
    public void setLabel(@Nullable String label) {
        this.computer.setLabel(label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startTimer(long ticks) {
        Int2ObjectMap<Timer> int2ObjectMap = this.timers;
        synchronized (int2ObjectMap) {
            this.timers.put(this.nextTimerToken, (Object)new Timer(ticks));
            return this.nextTimerToken++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelTimer(int id) {
        Int2ObjectMap<Timer> int2ObjectMap = this.timers;
        synchronized (int2ObjectMap) {
            this.timers.remove(id);
        }
    }

    @Override
    public MetricsObserver metrics() {
        return this.metrics;
    }

    private static class Timer {
        long ticksLeft;

        Timer(long ticksLeft) {
            this.ticksLeft = ticksLeft;
        }
    }
}

